package repositories;

import objects.Team;
import objects.User;
import org.mongodb.morphia.Datastore;

import javax.inject.Inject;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

/**
 * Created by gpietrus on 20.02.2016.
 */
public class TeamsRepository implements Repository {

    private Datastore datastore;

    @Inject
    public TeamsRepository(Datastore datastore) {
        this.datastore = datastore;
    }

    public Optional<Team> getTeamByUser(User user) {
        return datastore.createQuery(Team.class).asList().stream()
                .filter(team -> team.getMembers().contains(user))
                .findFirst();
    }

    public void get(UUID uuid) {

    }

    public List<Team> getAll() {
        return datastore.createQuery(Team.class).asList();
    }

    //todo: move to interface
    public void add(Team team) {
        datastore.save(team);
    }

    public void clean() {
        datastore.getCollection(Team.class).drop();
    }

}
