(function(){
    angular.module('ctfApp').controller('TaskController', ['$scope', '$stateParams', 'APIProvider', 'AppSettings', function($scope, $stateParams, APIProvider, AppSettings) {
        $scope.submitUnknown = false;
        $scope.apiAddress = AppSettings.getApiAddress();
        $scope.selectedTaskId = $stateParams.taskLevel;
        // console.log('SELECTED TASK ID', $scope.selectedTaskId);
        APIProvider.getTaskById($scope.selectedTaskId, function(data){
            // console.log(data);
            $scope.task = data;
        });
        $scope.submitFlag = function(){
            var $flag = $('input#flag-to-submit');
            $scope.submitUnknown = true;
            APIProvider.submitFlag($stateParams.taskLevel, $flag.val()).success(function(data){
                Materialize.toast('Poprawna flaga! :)', 5000, 'toast-success');
                if (!$scope.task.completedFlags){
                    $scope.task.completedFlags = [];
                }
                $scope.task.completedFlags.push(data);
                $scope.submitUnknown = false;
                $flag.val('');
            }).error(function(){
                Materialize.toast('Błędna flaga! :(', 5000 ,'toast-error');
                $scope.submitUnknown = false;
            });
        };
    }]);
})();