package repositories;

import database.MongoDBConnector;
import objects.Team;
import objects.User;

import java.util.Collection;
import java.util.Optional;

/**
 * Created by gpietrus on 20.02.2016.
 */
public class UsersRepository implements Repository {

    private MongoDBConnector mongoDBConnector;
    private TeamsRepository teamsRepository;

    public UsersRepository(MongoDBConnector mongoDBConnector,
                           TeamsRepository teamsRepository) {
        this.mongoDBConnector = mongoDBConnector;
        this.teamsRepository = teamsRepository;
    }

    public Optional<User> get(String username) {
        Optional<User> userOptional = teamsRepository.getAll()
                .stream()
                .map(Team::getMembers)
                .flatMap(Collection::stream)
                .filter(user -> user.getName().equals(username))
                .findFirst();
        return userOptional;
    }

//    public void get(UUID uuid) {
//    }

//    public List<User> getAll() {
//        return mongoDBConnector.getCollection("users")
//                .stream()
//                .map((Function<Document, User>) User::new)
//                .collect(Collectors.toList());
//    }

//    public void add(User user) {
//        mongoDBConnector.addDocument("users", new Document(user.toMap()));
//    }

//    public void clean() {
//        mongoDBConnector.removeCollection("users");
//    }
}
