/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth;

import com.google.common.base.Preconditions;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.Authorizer;
import io.dropwizard.auth.DefaultUnauthorizedHandler;
import io.dropwizard.auth.PermitAllAuthorizer;
import io.dropwizard.auth.UnauthorizedHandler;
import java.security.Principal;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestFilter;

@Priority(value=1000)
public abstract class AuthFilter<C, P extends Principal>
implements ContainerRequestFilter {
    protected String prefix;
    protected String realm;
    protected Authenticator<C, P> authenticator;
    protected Authorizer<P> authorizer;
    protected UnauthorizedHandler unauthorizedHandler;

    public static abstract class AuthFilterBuilder<C, P extends Principal, T extends AuthFilter<C, P>> {
        private String realm = "realm";
        private String prefix = "Basic";
        private Authenticator<C, P> authenticator;
        private Authorizer<P> authorizer = new PermitAllAuthorizer();
        private UnauthorizedHandler unauthorizedHandler = new DefaultUnauthorizedHandler();

        public AuthFilterBuilder<C, P, T> setRealm(String realm) {
            this.realm = realm;
            return this;
        }

        public AuthFilterBuilder<C, P, T> setPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public AuthFilterBuilder<C, P, T> setAuthorizer(Authorizer<P> authorizer) {
            this.authorizer = authorizer;
            return this;
        }

        public AuthFilterBuilder<C, P, T> setAuthenticator(Authenticator<C, P> authenticator) {
            this.authenticator = authenticator;
            return this;
        }

        public AuthFilterBuilder<C, P, T> setUnauthorizedHandler(UnauthorizedHandler unauthorizedHandler) {
            this.unauthorizedHandler = unauthorizedHandler;
            return this;
        }

        public T buildAuthFilter() {
            Preconditions.checkArgument((this.realm != null ? 1 : 0) != 0, (Object)"Realm is not set");
            Preconditions.checkArgument((this.prefix != null ? 1 : 0) != 0, (Object)"Prefix is not set");
            Preconditions.checkArgument((this.authenticator != null ? 1 : 0) != 0, (Object)"Authenticator is not set");
            Preconditions.checkArgument((this.authorizer != null ? 1 : 0) != 0, (Object)"Authorizer is not set");
            Preconditions.checkArgument((this.unauthorizedHandler != null ? 1 : 0) != 0, (Object)"Unauthorized handler is not set");
            T authFilter = this.newInstance();
            ((AuthFilter)authFilter).authorizer = this.authorizer;
            ((AuthFilter)authFilter).authenticator = this.authenticator;
            ((AuthFilter)authFilter).prefix = this.prefix;
            ((AuthFilter)authFilter).realm = this.realm;
            ((AuthFilter)authFilter).unauthorizedHandler = this.unauthorizedHandler;
            return authFilter;
        }

        protected abstract T newInstance();
    }
}

