import api.ExampleResource;
import com.mongodb.client.FindIterable;
import database.MongoDatabaseConnector;
import io.dropwizard.Application;
import io.dropwizard.setup.Environment;
import objects.Fruit;
import org.bson.Document;
import org.mongolink.MongoSession;
import persistence.MongoRepositories;
import repositories.Repositories;
import stub.MongoConfiguration;

/**
 * Created by gpietrus on 16.02.16.
 */
public class CTFApplication extends Application<ApplicationConfiguration>
{
    @Override
    public void run(ApplicationConfiguration applicationConfiguration, Environment environment) throws Exception
    {
        environment.jersey().register(ExampleResource.class);
        MongoDatabaseConnector mongoDatabaseConnector = new MongoDatabaseConnector();
        FindIterable<Document> users = mongoDatabaseConnector.getUsers();
    }

    public static void main(String[] args) throws Exception
    {
        MongoSession session = MongoConfiguration.createSession();
        session.start();
        Repositories.initialise(new MongoRepositories(session));
        Repositories.fruits().add(new Fruit("apple"));
        session.stop();

        //new CTFApplication().run(args);
    }
}
