package com.telephoners.krakyournet.ctf.providers;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.telephoners.krakyournet.ctf.core.ApplicationConfiguration;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

@Singleton
public class MessageDigestProvider
{
    private ApplicationConfiguration applicationConfiguration;

    @Inject
    public MessageDigestProvider(ApplicationConfiguration applicationConfiguration)
    {
        this.applicationConfiguration = applicationConfiguration;
    }

    public MessageDigest getMessageDigest()
    {
        try {
            return MessageDigest.getInstance(applicationConfiguration.getDigestMethod());
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return null;
    }
}
