package api;

import io.dropwizard.auth.Auth;
import objects.User;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.InputStream;

/**
 * Created by gpietrus on 16.02.16.
 */
@Path(value = "/proxy/task")
@Produces(MediaType.APPLICATION_JSON)
public class ProxyResource {
  /*
    @GET
    @Path("{task_id}/{path: .*}")
    @Produces("text/html; charset=UTF-8")
    public InputStream foo(final @PathParam("task_id") String taskId,
                           final @PathParam("path") String path) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpget = new HttpGet("https://pl.wikipedia.org/" + taskId + "/" + path);
        CloseableHttpResponse execute = httpClient.execute(httpget);
        HttpEntity entity = execute.getEntity();
        return entity.getContent();
    }
*/
    @GET
    @Path("{task_id}/{path: .*}")
    @Produces("text/html; charset=UTF-8")
    public InputStream task1(@Auth User user,
                             final @PathParam("task_id") String taskId,
                             final @PathParam("path") String path) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpget = new HttpGet("http://192.168.56.101/");
//        HttpGet httpget = new HttpGet("http://http://192.168.56.101/" + taskId + "/" + path);
        httpget.setHeader("CTF-User", user.getName());
        CloseableHttpResponse execute = httpClient.execute(httpget);
        HttpEntity entity = execute.getEntity();
        return entity.getContent();
    }
}
