package api;

import io.dropwizard.auth.Auth;
import objects.Task;
import objects.User;
import repositories.TasksRepository;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.util.Collection;
import java.util.List;

/**
 * Created by gpietrus on 16.02.16.
 */
@Path(value = "/tasks")
@Produces(MediaType.APPLICATION_JSON)
public class TasksResource
{
    private TasksRepository tasksRepository;

    @Inject
    public TasksResource(TasksRepository tasksRepository) {
        this.tasksRepository = tasksRepository;
    }

    @GET
    public List<Task> getTasks() {
        return tasksRepository.getAll();
    }

    @GET
    @Path("my")
    public Collection<String> getUserFlags(@Auth User user) {
        return tasksRepository.getUserFlagsHashes(user.getName()).keySet();
    }

    @POST
    public boolean submitSolution(@Auth User user,
                                  String flag) throws Exception {
        return tasksRepository.checkFlag(user.getName(), flag);
    }

}
