package com.telephoners.krakyournet.ctf.repositories;

import org.mongodb.morphia.Datastore;

import javax.inject.Inject;
import java.lang.reflect.ParameterizedType;
import java.util.List;

public abstract class Repository<T>
{
    protected Datastore datastore;

    @Inject
    public Repository(Datastore datastore)
    {
        this.datastore = datastore;
    }

    protected Repository()
    {
    }

    abstract List<T> getAll();

    public void add(T item)
    {
        datastore.save(item);
    }

    Class getRepositoryType() throws ClassNotFoundException
    {
        return Class.forName((((ParameterizedType) this.getClass().getGenericSuperclass())
                .getActualTypeArguments()[0]).getTypeName());
    }

    public void clean() throws ClassNotFoundException
    {
        datastore.getCollection(getRepositoryType()).drop();
    }
}
