package repositories;

import io.dropwizard.auth.basic.BasicCredentials;
import objects.User;
import org.apache.commons.codec.binary.Hex;
import org.mongodb.morphia.Datastore;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;

/**
 * Created by gpietrus on 20.02.2016.
 */
public class UsersRepository implements Repository {

    private Datastore datastore;
    private TeamsRepository teamsRepository;
    private MessageDigest messageDigest;

    public UsersRepository(Datastore datastore,
                           TeamsRepository teamsRepository) {
        this.datastore = datastore;
        this.teamsRepository = teamsRepository;
        try {
            messageDigest = MessageDigest.getInstance("MD5"); //todo
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

//    public Optional<User> get(String username) {
//        Optional<User> userOptional = teamsRepository.getAll()
//                .stream()
//                .map(Team::getMembers)
//                .flatMap(Collection::stream)
//                .filter(user -> user.getName().equals(username))
//                .findFirst();
//        return userOptional;
//    }

    public User authenticateUser(BasicCredentials basicCredentials) {

        return datastore.createQuery(User.class)
                .field("name").equal(basicCredentials.getUsername())
                .field("password").equal(Hex.encodeHexString(messageDigest.digest(basicCredentials.getPassword().getBytes())))
                .get();
    }

    @Override
    public List getAll() {
        return null;
    }

//    public void get(UUID uuid) {
//    }

//    public List<User> getAll() {
//        return mongoDBConnector.getCollection("users")
//                .stream()
//                .map((Function<Document, User>) User::new)
//                .collect(Collectors.toList());
//    }

//    public void add(User user) {
//        mongoDBConnector.addDocument("users", new Document(user.toMap()));
//    }

//    public void clean() {
//        mongoDBConnector.removeCollection("users");
//    }
}
