package com.telephoners.krakyournet.ctf.repositories;

import com.telephoners.krakyournet.ctf.beans.Flag;
import com.telephoners.krakyournet.ctf.beans.Solution;
import com.telephoners.krakyournet.ctf.beans.Team;
import com.telephoners.krakyournet.ctf.beans.tasks.Task;
import org.mongodb.morphia.Datastore;

import javax.inject.Inject;
import javax.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@Singleton
public class SolutionsRepository implements Repository
{
    private Datastore datastore;

    @Inject
    public SolutionsRepository(Datastore datastore)
    {
        this.datastore = datastore;
    }

    public List<Solution> getAll()
    {
        return datastore.createQuery(Solution.class).asList();
    }

    public void add(Solution solution)
    { //todo
        datastore.save(solution); //todo: error handling?
        //todo: do not add if already exists
    }

    public List<Solution> getByTeam(Team team)
    {
        //todo: merge with upper
        //todo: use morphia filter
        return datastore.createQuery(Solution.class)
                .asList().stream()
                .filter(solution -> solution.getTeam().equals(team))
                .collect(Collectors.toList());
        //todo: group by task
    }

    public Map<Integer, List<String>> getTeamSolutions(Team team)
    {
        return getByTeam(team).stream()
                .collect(Collectors.groupingBy(new Function<Solution, Task>()
                {
                    @Override
                    public Task apply(Solution solution1)
                    {
                        return solution1.getTask();
                    }
                })).entrySet().stream()
                .collect(Collectors.toMap(
                        taskSolutions -> taskSolutions.getKey().getLevel(),
                        taskSolutions -> taskSolutions.getValue().stream()
                                .map(solution -> solution.getFlag().getDescription()).collect(Collectors.toList())
                ));
    }

    //todo: use datastore filter
    public boolean exists(Solution solution)
    {
        //todo: refactor, ugly ;(
        String value = solution.getFlag().getValue();
        Optional<Solution> matchedSolution = getAll().stream()
                .filter(new Predicate<Solution>()
                {
                    @Override
                    public boolean test(Solution solution)
                    {
                        return solution.getFlag().getValue().equals(value);
                    }
                })
                .findFirst();
        return matchedSolution.isPresent();
    }
}