module.exports = function(grunt) {
	grunt.initConfig({
		pkg: grunt.file.readJSON('package.json'),
		cssmin: {
			task: {
				src: ['./service/src/main/resources/assets/statics/css/*'],
				dest: './front_build/assets/statics/css/main.css.min'
			},
			options: {
				'banner': null,
				'keepSpecialComments': '*',
				'report': 'min'
			}
		},
//todo: add jshint, clean and others
		uglify: {
			task: {
				src: ['./service/src/main/resources/assets/statics/js/*.js',
				'./service/src/main/resources/assets/statics/js/controllers/*'],
				dest: './front_build/assets/statics/js/app.js.min'
			},
			options: {
				'mangle': {},
				'compress': {},
				'beautify': false,
				'expression': false,
				'report': 'min',
				'sourceMap': false,
				'sourceMapName': undefined,
				'sourceMapIn': undefined,
				'sourceMapIncludeSources': false,
				'enclose': undefined,
				'wrap': undefined,
				'exportAll': false,
				'preserveComments': undefined,
				'banner': '',
				'footer': ''
			}
		}
	});

	grunt.loadNpmTasks('grunt-contrib-cssmin');
//	grunt.loadNpmTasks('grunt-contrib-jshint');
	grunt.loadNpmTasks('grunt-contrib-uglify');

	grunt.registerTask('default', ['cssmin', 'uglify']);
//	grunt.registerTask('default', ['cssmin', 'jshint', 'uglify']);
};