package api;

import core.FlagChecker;
import io.dropwizard.auth.Auth;
import objects.Task;
import objects.User;
import repositories.SolutionsRepository;
import repositories.TasksRepository;
import repositories.TeamsRepository;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.util.List;

/**
 * Created by gpietrus on 16.02.16.
 */
@Path(value = "/tasks")
@Produces(MediaType.APPLICATION_JSON)
public class TasksResource
{
    private TasksRepository tasksRepository;
    private TeamsRepository teamsRepository;
    private SolutionsRepository solutionsRepository;
    private FlagChecker flagChecker;

    @Inject
    public TasksResource(TasksRepository tasksRepository, TeamsRepository teamsRepository,
                         SolutionsRepository solutionsRepository, FlagChecker flagChecker) {
        this.tasksRepository = tasksRepository;
        this.teamsRepository = teamsRepository;
        this.solutionsRepository = solutionsRepository;
        this.flagChecker = flagChecker;
    }

    @GET
    public List<Task> getTasks() {
        return tasksRepository.getAll();
    }

    @POST
    public boolean submitSolution(@Auth User user,
                                  String flag) throws Exception {
        return flagChecker.checkFlag(user.getName(), flag);
    }

}
