package com.telephoners.krakyournet.ctf.resources;

import com.telephoners.krakyournet.ctf.objects.User;
import com.telephoners.krakyournet.ctf.objects.tasks.Task;
import com.telephoners.krakyournet.ctf.repositories.TasksRepository;
import io.dropwizard.auth.Auth;
import org.apache.commons.collections.MapUtils;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.util.List;
import java.util.Map;

@Singleton
@Path(value = "/tasks")
@Produces(MediaType.APPLICATION_JSON)
public class TasksResource
{
    private TasksRepository tasksRepository;

    @Inject
    public TasksResource(TasksRepository tasksRepository)
    {
        this.tasksRepository = tasksRepository;
    }

    @GET
    public List<Task> getTasksPublic()
    {
        return tasksRepository.getAllPublic();
    }

    @GET
    @Path("/{username}")
    public Response getUserFlags(@Auth User user, final @PathParam("username") String username)
    {
        if (user.isAdmin()) {
            Map<List<String>, Integer> userFlagsHashes = tasksRepository.getUserFlagsHashes(username);
            return Response.ok().entity(MapUtils.invertMap(userFlagsHashes)).build();
        }
        return Response.status(Response.Status.UNAUTHORIZED).build();
    }
}
