(function(){
    angular.module('ctfApp').factory('APIProvider', ['$http', 'AppSettings', 'AuthenticationService', function($http, AppSettings, AuthenticationService){
        var tasks, teams, scores, myResults;
        return {


            getScores: function(callback){
                $http.get(AppSettings.getApiAddress() + '/solutions/all').
                    success(function(data) {
                        scores = data;
                        if (callback) callback(data);
                    });
            },

            getTasks: function(callback){
                $http.get(AppSettings.getApiAddress() + '/tasks').
                    success(function(data) {
                        this.getMySolutions(function(solutions){
                            if (solutions){
                                data.filter(function(task){
                                    return Object.keys(solutions).map(function(a){return parseInt(a);}).indexOf(task.level) !== -1;
                                }).map(function(task){
                                    task.completedFlags = solutions[task.level];
                                    return task;
                                });
                                tasks = data;
                                if (callback) callback(data);
                            }
                        });
                    }.bind(this));
            },

            getMySolutions: function(callback){
                if (!myResults){
                    $http.get(AppSettings.getApiAddress() + '/solutions/my').
                        success(function(data) {
                            myResults = data;
                            if (callback) callback(data);
                        });
                }
                else {
                    callback(myResults);
                }

                //var result;
                //if (!scores){
                //    this.getScores(function(data){
                //        result = this.getMySolutions(callback);
                //    }.bind(this));
                //}
                //else {
                //    var team = AuthenticationService.getTeamname();
                //    result = team ? scores[team] : undefined;
                //}
                //callback(result);
            },

            getTaskById: function(id, callback){
                var result;
                if (!tasks) {
                    this.getTasks(function(data){
                        result = this.getTaskById(id, callback);
                    }.bind(this));
                }
                else {
                    result = tasks.filter(function(task){
                        return task.level == id;
                    })[0];
                }
                callback(result);
            },


            getMySubmittedFlagsForTask: function(id){

            },

            /**
             * Returns an array of completed levels' ids.
             * @param callback
             */
            getMyCompletedLevelsList: function(callback){
                $http.get(AppSettings.getApiAddress() + '/solutions/my/completed').
                    success(function(data) {
                        if (callback) callback(data);
                    });
            },

            /**
             *
             * @param level
             * @param flag
             * @returns {HttpPromise}
             */
            submitFlag: function(level, flag){
                return $http.post(AppSettings.getApiAddress() + '/solutions/' + level, flag).success(function(data){
                    $.each(tasks, function(task){
                        if (task.level == level){
                            if (!task.completedFlags){
                                task.completedFlags = [];
                            }
                            task.completedFlags.push(data);
                        }
                    });
                }.bind(this));
            }
        };
    }]);
})();