package com.telephoners.krakyournet.ctf.resources;

import com.telephoners.krakyournet.ctf.beans.User;
import com.telephoners.krakyournet.ctf.beans.tasks.Task;
import com.telephoners.krakyournet.ctf.repositories.TasksRepository;
import io.dropwizard.auth.Auth;
import org.glassfish.jersey.server.ContainerRequest;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import java.io.IOException;

@Singleton
@Path(value = "/task")
public class TaskResource
{
    private static final String KYN_HEADER_NAME = "KYN_2016"; //todo

    private final TasksRepository tasksRepository;

    @Inject
    public TaskResource(TasksRepository tasksRepository)
    {
        this.tasksRepository = tasksRepository;
    }

    @Path("{task_level}/{path: .*}")
    @GET
    public Response getTask(@Auth User user,
                            final @PathParam("task_level") int taskLevel,
                            final @PathParam("path") String path,
                            @Context ContainerRequestContext containerRequestContext) throws IOException
    {
        Task task = tasksRepository.getByLevel(taskLevel);
        //todo: refactor, path not necessary in textTasks
        ContainerRequest context = (ContainerRequest) containerRequestContext;
        String query = context.getRequestUri().getQuery();
        String kynHeaderValue = context.getHeaderString(KYN_HEADER_NAME);
        String fullPath = path;
        if(query != null) { //todo: refactor
            fullPath = fullPath + "?" + query;
        }
        return Response.ok().entity(task.getTextForUser(user, fullPath, kynHeaderValue)).build();
    }
}
