(function(){
    angular.module('ctfApp').factory('APIProvider', ['$http', 'AppSettings', function($http, AppSettings){
        var tasks, teams, scores;
        return {
            getScores: function(){},
            getTasks: function(callback){
                $http.get('http://' + AppSettings.apiAddress + '/tasks').
                    success(function(data) {
                        tasks = data;
                        if (callback) callback(data);
                    });
            },
            getTaskById: function(id, callback){
                var result;
                if (!tasks) {
                    this.getTasks(function(data){
                        result = this.getTaskById(id, callback);
                    }.bind(this));
                }
                else {
                    result = tasks.filter(function(task){
                        return task.level == id;
                    })[0];
                }
                callback(result);
            },
            submitFlag: function(flag){
                return $http.post('http://' + AppSettings.apiAddress + '/solutions', flag);
            }
        };
    }]);
})();