package repositories;

import core.ApplicationConfiguration;
import objects.Solution;
import objects.Task;
import objects.Team;
import objects.User;
import org.apache.commons.codec.binary.Hex;
import org.mongodb.morphia.Datastore;

import javax.inject.Inject;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * Created by gpietrus on 20.02.2016.
 */
public class TasksRepository implements Repository {

    private ApplicationConfiguration applicationConfiguration;
    private Datastore datastore;
    private TeamsRepository teamsRepository;
    private SolutionsRepository solutionsRepository;
    private UsersRepository usersRepository;
    private String salt = "SECURE_SALT"; //todo

    @Inject
    public TasksRepository(ApplicationConfiguration applicationConfiguration, Datastore datastore,
                           TeamsRepository teamsRepository, SolutionsRepository solutionsRepository,
                           UsersRepository usersRepository) {
        this.applicationConfiguration = applicationConfiguration;
        this.datastore = datastore;
        this.teamsRepository = teamsRepository;
        this.solutionsRepository = solutionsRepository;
        this.usersRepository = usersRepository;
    }

    public Task get(String taskName) { //todo: task name?
        return datastore.createQuery(Task.class)
                .filter("name", taskName)
                .get();
    }

    public Task get(int level) {
        return datastore.createQuery(Task.class)
                .filter("level", level)
                .get();
    }

    public List<Task> getAll() {
        return datastore.createQuery(Task.class).asList();
    }

    public void add(Task task) {
        datastore.save(task);
    }

    public void clean() {
        datastore.getCollection(Task.class).drop();
    }

    public Map<String, Task> getUserFlagsHashes(String username) {
        return this.getAll().stream()
                .collect(Collectors.toMap(
                        task -> calculateHashValue(username, task.getFlag().getValue()),
                        task -> task
                ));
    }

    public String calculateHashValue(String username, String flagValue) { //todo
        String combinedStrings = salt + username + flagValue; //todo
        MessageDigest md5 = null;//todo: discuss
        try {
            md5 = MessageDigest.getInstance(applicationConfiguration.getFlagHashMethod());
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        String encodedHash = Hex.encodeHexString(md5.digest(combinedStrings.getBytes()));
        return encodedHash;
    }

    private void acceptSolution(String username, Task task) {
        User user = usersRepository.getUserByName(username);
        Optional<Team> team = teamsRepository.getTeamByUser(user);
        if(team.isPresent()) {
            solutionsRepository.add(new Solution(team.get(),task.getName()));
        }
    }

    private boolean compareHash(String hash, String username) throws Exception {
        Task task = getUserFlagsHashes(username).get(hash);

        if (task != null) {
            acceptSolution(username, task);
            return true;
        }
        return false;
    }

    public boolean checkFlag(String username, String flagValue) throws Exception {
        return compareHash(flagValue, username);
        //todo: accept solution should be here
    }

    public Optional<String> getUserTaskFlag(String username, String taskId) {
        //todo: taskId, level, name? discuss
        return getUserFlagsHashes(username).entrySet().stream()
                .filter(taskEntry -> taskEntry.getValue().getName().equals(taskId))
                .map(taskEntry -> calculateHashValue(username, taskEntry.getValue().getFlag().getValue()))
                .findFirst();
    }
}

//todo: generify!