import api.ExampleResource;
import com.google.common.collect.Lists;
import com.mongodb.*;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import database.MongoDatabaseConnector;
import io.dropwizard.Application;
import io.dropwizard.setup.Environment;
import objects.Fruit;
import objects.User;
import org.bson.Document;
import org.mongolink.MongoSession;
import persistence.MongoRepositories;
import repositories.Repositories;
import stub.MongoConfiguration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * Created by gpietrus on 16.02.16.
 */
public class CTFApplication extends Application<ApplicationConfiguration> {
    @Override
    public void run(ApplicationConfiguration applicationConfiguration, Environment environment) throws Exception {
//        environment.jersey().register(ExampleResource.class);
//        MongoDatabaseConnector mongoDatabaseConnector = new MongoDatabaseConnector();
//        FindIterable<Document> users = mongoDatabaseConnector.getUsers();
    }

    public static void main(String[] args) throws Exception {

        //todo: add mongo-java-driver as maven dep
        User user = new User(String.valueOf(UUID.randomUUID()), "mehow");

        MongoClient mongoClient = new MongoClient("localhost", 27017);
        MongoDatabase database = mongoClient.getDatabase("db");

        MongoCollection<Document> usersCollection = database.getCollection("users");

        usersCollection.drop(); //todo: remove

        usersCollection.insertOne(new Document(user.toMap()));

        ArrayList<Document> usersDocuments = DBUtils.toList(usersCollection.find());

        List<Object> users = usersDocuments.stream()
                .map(User::new)
                .collect(Collectors.toList());

    }
}
