package com.telephoners.krakyournet.ctf.repositories;

import com.google.inject.Inject;
import com.telephoners.krakyournet.ctf.beans.Team;
import com.telephoners.krakyournet.ctf.core.DataConnector;

public class TeamRepository extends Repository<Team>
{
    @Inject
    public TeamRepository(final Class<Team> type, final DataConnector<Team> connector)
    {
        super(type, connector);
    }

    //todo: this should be handled by driver itself
    //todo: merge with User
    public boolean exists(final String teamName)
    {
        return getAll()
                .stream()
                .anyMatch(team -> team.getName().equals(teamName));
    }
}
