(function(){

    'use strict';

    var app = angular.module('ctfApp', ['ui.router', 'ncy-angular-breadcrumb', 'ngCookies']);

    app.config(['$stateProvider', '$urlRouterProvider', function($stateProvider, $urlRouterProvider) {

        $urlRouterProvider.otherwise('/home');

        $stateProvider

            .state('home', {
                url: '/home',
                templateUrl: '/home.html'
            })

            .state('login', {
                url: '/login',
                templateUrl: '/login.html'
            })

            .state('tasks', {
                url: '/tasks',
                templateUrl: '/tasks.html'
            })

            .state('task', {
                url: '/task/:taskLevel',
                templateUrl: '/task.html'
            })

            .state('scores', {
                url: '/scores',
                templateUrl: '/scoresheet.html'
            });

    }]);

    app.factory('AppSettings', function() {
        var dev = "localhost:8080/api/v1", prod = "52.28.244.24:8080/api/v1";
        return {
            apiAddress: prod
        };
    });

    app.config(['$httpProvider', function ($httpProvider) {

        $httpProvider.interceptors.push(['$q', function ($q) {
            return {
                'response': function (response) {
                    return response || $q.when(response);
                },
                'responseError': function (rejection) {
                    return $q.reject(rejection);
                }
            };
        }]);

    }]);

    app.run(['$rootScope', '$location', '$cookieStore', '$http', 'NavbarService',
        function ($rootScope, $location, $cookieStore, $http, NavbarService) {

            $(".button-collapse").sideNav();

            // keep user logged in after page refresh
            $rootScope.globals = $cookieStore.get('globals') || {};

            console.log("No dobra, ta jest prosta - na zachętę! :)");
            console.log("--> KYN2016_EmacsemPrzezSendmaila <--");
            console.log("Have fun!");

            var username = $rootScope.globals.currentUser ? $rootScope.globals.currentUser.username : 'guest';

            $(".title").typed({
                strings: NavbarService.getTypedStrings(username),
                startDelay: 10,
                backDelay: 500,
                whenToStop: 17 + username.length
            });

            if ($rootScope.globals.currentUser) {
                $http.defaults.headers.common['Authorization'] = 'Basic ' + $rootScope.globals.currentUser.authdata; // jshint ignore:line
            }

            $rootScope.$on('$locationChangeStart', function (event, next, current) {
                // redirect to login page if not logged in
                if ($location.path() !== '/login' && !$rootScope.globals.currentUser) {
                    $location.path('/login');
                }
            });

            $(document).ready(function(){
               $('#background').css('background-image', "url('/statics/img/door.png')");
            });



            (function(){
                var bkg = $('#background');
                var count = 0;
                var snd1 = new Audio('data:audio/mp3;base64,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');
                var snd2 = new Audio('data:audio/mp3;base64,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');
                var snd3 = new Audio('data:audio/mp3;base64,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');
                var snds = [snd1, snd2, snd3];
                var state = false;

                var fun = function(){
                    snds[count].play();
                    if (count >= 2){
                        bkg.css('background-image', "url('statics/img/off.png')");
                        bkg.css('height', '83px');
                        bkg.css('width', '51px');
                        bkg.css('bottom', '140px');
                        bkg.css('right', '300px');
                        bkg.off('click', fun);
                        bkg.on('click', fun2);
                    }
                    else {
                        count = count + 1;
                    }
                };
                var fun2 = function(){
                    if (state){
                        // light is on, turn it off
                        bkg.css('background-image', "url('statics/img/off.png')");
                        $('body').css('background-image', "url('statics/img/bkg.jpg')");
                        state = false;
                    }
                    else {
                        //light is off, turn it on
                        bkg.css('background-image', "url('statics/img/on.png')");
                        $('body').css('background-image', "url('statics/img/bkg.jpeg')");
                        state = true;
                    }
                };

                bkg.on('click', fun);

            })();


        }]);

})();


