package com.telephoners.krakyournet.ctf.commands;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.telephoners.krakyournet.ctf.core.ApplicationConfiguration;
import com.telephoners.krakyournet.ctf.modules.ApplicationModule;
import com.telephoners.krakyournet.ctf.beans.tasks.TextTask;
import com.telephoners.krakyournet.ctf.beans.tasks.WebTask;
import com.telephoners.krakyournet.ctf.repositories.TasksRepository;
import io.dropwizard.cli.ConfiguredCommand;
import io.dropwizard.setup.Bootstrap;
import net.sourceforge.argparse4j.inf.Namespace;

import java.util.List;

public class RegisterTasksCommand extends ConfiguredCommand<ApplicationConfiguration>
{
    private static final String COMMAND_NAME = "registertasks";
    private static final String COMMAND_DESCRIPTION = "Register tasks";

    public RegisterTasksCommand()
    {
        super(COMMAND_NAME, COMMAND_DESCRIPTION);
    }

    private void initializeTasks(ApplicationConfiguration applicationConfiguration, Injector injector)
    {
        TasksRepository tasksRepository = injector.getInstance(TasksRepository.class);

        List<TextTask> cryptoTasks = applicationConfiguration.getTextTasks();
        List<WebTask> webTasks = applicationConfiguration.getWebTasks();

//        tasksRepository.clean();

        cryptoTasks.forEach(tasksRepository::add);
        webTasks.forEach(tasksRepository::add);
    }

    @Override
    protected void run(Bootstrap<ApplicationConfiguration> bootstrap, Namespace namespace, ApplicationConfiguration applicationConfiguration) throws Exception
    {
        Injector injector = Guice.createInjector(new ApplicationModule(applicationConfiguration));
        initializeTasks(applicationConfiguration, injector);
    }
}
