package resources;

import io.dropwizard.auth.Auth;
import objects.User;
import objects.tasks.Task;
import org.apache.commons.collections.MapUtils;
import repositories.TasksRepository;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.util.List;
import java.util.Map;

@Singleton
@Path(value = "/tasks")
@Produces(MediaType.APPLICATION_JSON)
public class TasksResource
{
    private TasksRepository tasksRepository;

    @Inject
    public TasksResource(TasksRepository tasksRepository)
    {
        this.tasksRepository = tasksRepository;
    }

    @GET
    public List<Task> getTasksPublic()
    {
        return tasksRepository.getAllPublic();
    }

    @GET
    @Path("/{username}")
    public Response getUserFlags(@Auth User user, final @PathParam("username") String username)
    {
        if (user.isAdmin()) {
            Map<List<String>, Integer> userFlagsHashes = tasksRepository.getUserFlagsHashes(username);
            return Response.ok().entity(MapUtils.invertMap(userFlagsHashes)).build();
        }
        return Response.status(Response.Status.UNAUTHORIZED).build();
    }
}
