package objects.tasks;

import com.fasterxml.jackson.annotation.JsonInclude;
import core.TaskType;
import helpers.PublicProperty;
import objects.DBObject;
import objects.Flag;
import org.bson.types.ObjectId;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.annotations.Id;

import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Entity("tasks")
@JsonInclude(JsonInclude.Include.NON_NULL)
public class Task extends DBObject
{
    @Id
    private ObjectId id;
    @PublicProperty
    private String name;
    @PublicProperty
    private int level;
    private TaskType taskType;
    private List<Flag> flags;
    private TaskContent taskContent;

    public Task(String name, int level, TaskType type, List<Flag> flags, TaskContent taskContent)
    {
        this.flags = flags;
        this.taskType = type;
        this.level = level;
        this.name = name;
        this.taskContent = taskContent;
    }

    public Task()
    {
    }

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    public int getLevel()
    {
        return level;
    }

    public void setLevel(int level)
    {
        this.level = level;
    }

    public TaskType getTaskType()
    {
        return taskType;
    }

    public void setTaskType(TaskType taskType)
    {
        this.taskType = taskType;
    }

    public List<Flag> getFlags()
    {
        return flags;
    }

    public void setFlags(List<Flag> flags)
    {
        this.flags = flags;
    }

    public TaskContent getTaskContent()
    {
        return taskContent;
    }

    public void setTaskContent(TaskContent taskContent)
    {
        this.taskContent = taskContent;
    }
}
