package objects;

import helpers.PublicProperty;
import objects.tasks.Task;

import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DBObject
{
    public static String[] getPublicFields(Class<Task> taskClass) //todo: do not use argument
    {
        //todo: get upper class
        Field[] declaredFields = taskClass.getDeclaredFields(); //todo: declared or not declared?
        List<String> publicFieldsNames = Stream.of(declaredFields)
                .filter(field -> field.getAnnotation(PublicProperty.class) != null)
                .map(Field::getName)
                .collect(Collectors.toList());

        return publicFieldsNames.toArray(new String[publicFieldsNames.size()]);
    }
}
