package resources.tasks;


import core.TaskType;
import io.dropwizard.auth.Auth;
import objects.User;
import objects.tasks.Task;
import objects.tasks.TaskCryptoContent;
import repositories.TasksRepository;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

/**
 * Created by gpietrus on 23.02.2016.
 */
@Produces(MediaType.APPLICATION_JSON)
public class CryptoTaskResource extends TaskResource {
    public CryptoTaskResource(TasksRepository tasksRepository) {
        super(tasksRepository);
    }

//    private TasksRepository tasksRepository;

//    @Inject
//    public CryptoTaskResource(TasksRepository tasksRepository) {
//        this.tasksRepository = tasksRepository;
//    }

    //todo: merge crypto and web task?
//    @Override
    @Path("crypto/{task_level}")
    @GET
    //todo: auth
    public Response getTask(@Auth User user,
                            final @PathParam("task_level") int taskLevel) {

        Task task = tasksRepository.get(taskLevel);//todo
        if(task == null || !task.getTaskType().equals(TaskType.CRYPTO)) {
            return Response.status(Response.Status.BAD_REQUEST).build();

        }
        TaskCryptoContent taskContent = (TaskCryptoContent) task.getTaskContent();
        return Response.ok().entity(taskContent.getText()).build();
    }
}
