from uuid import UUID

from functools import partial

import models
import csv

from tornado.gen import coroutine
from tornado.ioloop import IOLoop

@coroutine
def main():
    with open("syfy.csv", 'r') as csvfile:
        reader = csv.reader(csvfile)
        next(reader)
        for row in reader:
            uuid = UUID(int=int(row[0]))
            station = models.Type(shortname=row[1], longname=row[2], description=row[2], norm=row[5], unit=row[4],
                                  type_id=uuid)
            result = yield station.save()

IOLoop.current().run_sync(main)
