import uuid
from unittest.mock import MagicMock, patch

from asynctest import CoroutineMock
from models import Type
from tornado.testing import AsyncTestCase, gen_test

class TypeTest(AsyncTestCase):
    def setUp(self):
        Type.stored = {}
        super(TypeTest, self).setUp()
        self.id = uuid.uuid4()
        self.shortname = "test_shortname"
        self.unit = "test_unit"
        self.norm = 57
        self.longname = "test_longname"
        self.description = "test_description"
        self.type = Type(shortname=self.shortname, unit=self.unit, norm=self.norm, longname=self.longname,
                         description=self.description, type_id=self.id)

    @gen_test
    def test_init(self):
        self.assertEqual(self.type.id, self.id)
        self.assertEqual(self.type.shortname, self.shortname)
        self.assertEqual(self.type.unit, self.unit)
        self.assertEqual(self.type.norm, self.norm)
        self.assertEqual(self.type.longname, self.longname)
        self.assertEqual(self.type.description, self.description)

    @gen_test
    def test_get_from_storage(self):
        Type.stored = {self.type.id: self.type}
        result = yield Type.get(self.type.id)

        self.assertEqual(result, self.type)

    @gen_test
    def test_get(self):
        with patch('models.DDBtypes') as mock_types:
            mock_types.return_value.get = CoroutineMock()
            mock_types.return_value.get.return_value = {
                'type_id': self.id,
                'shortname': self.shortname,
                'unit': self.unit,
                'norm': self.norm,
                'longname': self.longname,
                'description': self.description
            }
            result = yield Type.get(self.type.id)

        self.assertEqual(result.id, self.id)
        self.assertEqual(result.shortname, self.shortname)
        self.assertEqual(result.unit, self.unit)
        self.assertEqual(result.norm, self.norm)
        self.assertEqual(result.longname, self.longname)
        self.assertEqual(result.description, self.description)

# import models
#
# station = models.Station(1, "Kraków", 12, 13, "Aleje")
# station.save()
# station2 = models.Station.get(station.id)
# assert station.id == station2.id
#
# pollution_type = models.Type(shortname="pm2", unit="mg", norm=120, longname="long_pm2", description="description pm2")
# pollution_type.save()
# pollution_type2 = models.Type.get(pollution_type.id)
# assert pollution_type.id == pollution_type2.id
#
# measurement = models.Measurement(station=station, pollution_type=pollution_type, value=13, time=124)
# measurement.save()
# measurement2 = models.Measurement.get(measurement.id)
# assert measurement.id == measurement2.id