import sys

import tornado.ioloop
import tornado.web
import models
from tornado import gen
import json


class MainHandler(tornado.web.RequestHandler):
    @gen.coroutine
    def get(self):
        stations = yield models.Station.get_all()
        pollutions = yield models.Type.get_all()
        last_measurements = yield models.Measurement.get_all_last()
        response = dict()
        for measurement in last_measurements:
            data = {
                "station_name" : measurement.station.name,
                "type" : measurement.type.shortname,
                "value" : measurement.value,
                "time" : measurement.time
            }
            response[measurement.id] = data
        self.set_header('Content-Type', 'application/json')
        self.write(json.dumps(response))        


def make_app():
    return tornado.web.Application([
        (r"/view", MainHandler),
        (r'/()', tornado.web.StaticFileHandler, {'path': '/home/smok/smogonet/index.html'})
    ])

if __name__ == "__main__":
    app = make_app()
    port = 80
    if len(sys.argv) > 1:
        port = sys.argv[1]
    app.listen(port)
    tornado.ioloop.IOLoop.current().start()
