from uuid import UUID

import models
import csv

from tornado.gen import coroutine
from tornado.ioloop import IOLoop

@coroutine
def main():
    with open("stations.csv", 'r') as csvfile:
        reader = csv.reader(csvfile)
        next(reader)
        for row in reader:
            print(row)
            uuid = UUID(int=int(row[0]))
            station = models.Station(station_id=uuid, city=row[2], name=row[1], longitude=float(row[3])*10e6,
                                     latitude=float(row[4])*10e6, api_station_id=row[0])
            result = yield station.save()

IOLoop.current().run_sync(main)
