import sys

import tornado.ioloop
import tornado.web
import models
from tornado import gen


class MainHandler(tornado.web.RequestHandler):
    @gen.coroutine
    def get(self):
        stations = yield models.Station.get_all()
        pollutions = yield models.Type.get_all()
        last_measurements = yield models.Measurement.get_all_last()

        for measurement in last_measurements:
            self.write(str(measurement))
            self.write("\n")


def make_app():
    return tornado.web.Application([
        (r"/view", MainHandler),
    ])

if __name__ == "__main__":
    app = make_app()
    port = 80
    if len(sys.argv) > 1:
        port = sys.argv[1]
    app.listen(port)
    tornado.ioloop.IOLoop.current().start()
