var Map = (function(){
    this.init();
    var myLatLng;
    var markers;
    var map;
})

Map.prototype.init = function(){
    var self = this;
    this.myLatLng = {lat: 50.049765, lng: 19.946762};
    this.map = new google.maps.Map(document.getElementById('gmaps'), {
        zoom: 4,
        center: self.myLatLng
    });
    this.markers = [];

    this.getAllBeacons();
}

Map.prototype.addMarker = function(data){
    var self = this;
    var color = data.color || "FE7569";
    var longitude = parseFloat(data.longitude);
    var latitude = parseFloat(data.latitude);
    var image = new google.maps.MarkerImage("http://chart.apis.google.com/chart?chst=d_map_pin_letter&chld=%E2%80%A2|" + color,
    new google.maps.Size(21, 34),
    new google.maps.Point(0,0),
    new google.maps.Point(10, 34));

    var marker = new google.maps.Marker({
        position: {lat: latitude, lng:longitude},
        map: self.map,
        icon: image,
        title: data.title,
        beacon: data.beacon
      }).addListener('click', function() {
        self.showInfo(this.beacon)
      })
    self.markers.push(marker)

}

Map.prototype.getAllBeacons = function(){
    var self = this;
    $.getJSON("/api/beacons", function(data){
        for(var i=0; i<data.count; i++){
            self.addMarker({
                color: "FE7569",
                longitude: data.results[i].longitude,
                latitude: data.results[i].latitude,
                title: [data.results[i].uuid, "(", data.results[i].name, ")"].join(""),
                beacon: data.results[i]
            });
        }
    })
}

Map.prototype.showInfo = function(beacon){
    $("#myModalLabel").text([beacon.name, " (", beacon.uuid, ")"].join(""))
    $("#modal-content").html([
    '<div class="col-md-6">',
    'description:',
    '</div>',
    '<div class="col-md-6">',
    beacon.description,
    '</div>',
    '<div class="col-md-6">',
    'name:',
    '</div>',
    '<div class="col-md-6">',
    beacon.name,
    '</div>',
    '<div class="col-md-6">',
    'uuid:',
    '</div>',
    '<div class="col-md-6">',
    beacon.uuid,
    '</div>',
    '<div class="col-md-6">',
    'longitude:',
    '</div>',
    '<div class="col-md-6">',
    beacon.longitude,
    '</div>',
    '<div class="col-md-6">',
    'latitude:',
    '</div>',
    '<div class="col-md-6">',
    beacon.latitude,
    '</div>',
    '<div class="clearfix"></div>'].join(""))
    $("#myModal").modal("show");
//    alert('marker klikniety' + marker.beacon.uuid)
}