from django.core.exceptions import ObjectDoesNotExist
from django.shortcuts import render

# Create your views here.
from rest_framework import viewsets
import rest_framework
from rest_framework.response import Response
from rest_framework.views import APIView
from Hub.models import Beacon, BeaconManager, Site, Category
from Hub.serializers import BeaconSerializer, BeaconManagerSerializer, SiteSerializer, CategorySerializer


class BeaconViewSet(viewsets.ModelViewSet):
    """
    API for places
    """
    queryset = Beacon.objects.all()
    serializer_class = BeaconSerializer

class BeaconManagerViewSet(viewsets.ModelViewSet):
    """
    API for places
    """
    queryset = BeaconManager.objects.all()
    serializer_class = BeaconManagerSerializer

class SiteViewSet(viewsets.ModelViewSet):
    """
    API for places
    """
    queryset = Site.objects.all()
    serializer_class = SiteSerializer



class UuidBeaconViewSet(APIView):
    """
    API for places
    """
    queryset = Beacon.objects.all()
    serializer_class = BeaconSerializer

    def get(self, request, pk, category_name = None,format=None):
        beacon = Beacon.objects.get(uuid = pk)
        beacon_manager = BeaconManager.objects.get(beacon=beacon)
        if category_name:
            try:
                category = Category.objects.get(name=category_name)
            except ObjectDoesNotExist:
                return Response(status=rest_framework.status.HTTP_400_BAD_REQUEST, data={"This category is not exist"})
            try:
                site = beacon_manager.sites.Category.objects.get(category=category)
            except ObjectDoesNotExist:
                return Response(status=rest_framework.status.HTTP_400_BAD_REQUEST, data={"Any link do not have this category"})
            serializer = SiteSerializer(site, context={'request': request})
            return Response(serializer.data)
        serializer = SiteSerializer(beacon_manager.sites, many=True, context={'request': request})
        return Response(serializer.data)

class CategoryViewSet(viewsets.ModelViewSet):
    """
    API for places
    """
    queryset = Category.objects.all()
    serializer_class = CategorySerializer