from django.contrib.auth.models import User
from django.db import models


# Create your models here.

class Site(models.Model):
    link_url = models.CharField(max_length=2000)
    description = models.CharField(max_length=300, null=True)
    category = models.ManyToManyField('Category', blank=True)
    author = models.ForeignKey(User)

    def __str__(self):
        return self.link_url

class Category(models.Model):
    name = models.CharField(max_length=300, null=True)
    private = models.BooleanField()

    def __str__(self):
        return self.name


class Beacon(models.Model):
    uuid = models.CharField(max_length=300, unique=True)
    name = models.CharField(max_length=300)
    description = models.CharField(max_length=300, null=True)
    longitude = models.DecimalField(max_digits=9, decimal_places=6)
    latitude = models.DecimalField(max_digits=9, decimal_places=6)
    beacon_manager = models.OneToOneField('BeaconManager', blank=True, related_name='beacon_manager')

    def __str__(self):
        return "name: {name}, uuid:{uuid}".format(name=self.name, uuid=self.uuid)


class BeaconManager(models.Model):
    beacon = models.OneToOneField('Beacon')
    sites = models.ManyToManyField('Site', blank=True)

    def __str__(self):
        return str(self.beacon)

class UserProject(models.Model):
    author = models.ForeignKey(User)
    beacon_managers = models.ManyToManyField('BeaconManager', blank=True)
    name = models.CharField(max_length=300)
    description = models.CharField(max_length=300, null=True)

    def __str__(self):
        return self.name