var Map = (function(){
    this.init();
    var myLatLng;
    var markers;
    var map;
})

Map.prototype.init = function(){
    var self = this;
    this.myLatLng = {lat: 50.049765, lng: 19.946762};
    this.map = new google.maps.Map(document.getElementById('gmaps'), {
        zoom: 4,
        center: self.myLatLng
    });
    this.markers = [];

    this.getAllBeacons();
}

Map.prototype.addMarker = function(data){
    var self = this;
    if(project_summary['uuids'].indexOf(data.beacon.uuid) === -1){
        var color = "FE7569";
    }
    else{
        var color = "FFFF00";
    }
    var longitude = parseFloat(data.longitude);
    var latitude = parseFloat(data.latitude);
    var image = new google.maps.MarkerImage("http://chart.apis.google.com/chart?chst=d_map_pin_letter&chld=%E2%80%A2|" + color,
    new google.maps.Size(21, 34),
    new google.maps.Point(0,0),
    new google.maps.Point(10, 34));

    var marker = new google.maps.Marker({
        position: {lat: latitude, lng:longitude},
        map: self.map,
        icon: image,
        title: data.title,
        beacon: data.beacon
      }).addListener('click', function() {
          self.showInfo(this.beacon)
      })
    self.markers.push(marker)

}

Map.prototype.getAllBeacons = function(){
    var self = this;
    $.getJSON("/api/user_project/" + project_id + "/beacons", function(data){
        project_data = data
        project_summary['uuids'] = [];
        for(var i=0; i< data.length; i++){
            project_summary['uuids'].push(project_data[i].uuid)
        }
        $.getJSON("/api/beacons", function(data){
            for(var i=0; i<data.count; i++){
                self.addMarker({
                    color: "FE7569",
                    longitude: data.results[i].longitude,
                    latitude: data.results[i].latitude,
                    title: [data.results[i].uuid, "(", data.results[i].name, ")"].join(""),
                    beacon: data.results[i]
                });
            }
        })
    })
}

Map.prototype.showInfo = function(beacon){
    $("#myModalLabel").text([beacon.name, " (", beacon.uuid, ")"].join(""))
    $("#modal-content").html([
    '<div class="col-md-6">',
    'description:',
    '</div>',
    '<div class="col-md-6">',
    beacon.description,
    '</div>',
    '<div class="col-md-6">',
    'name:',
    '</div>',
    '<div class="col-md-6">',
    beacon.name,
    '</div>',
    '<div class="col-md-6">',
    'uuid:',
    '</div>',
    '<div class="col-md-6">',
    beacon.uuid,
    '</div>',
    '<div class="col-md-6">',
    'longitude:',
    '</div>',
    '<div class="col-md-6">',
    beacon.longitude,
    '</div>',
    '<div class="col-md-6">',
    'latitude:',
    '</div>',
    '<div class="col-md-6">',
    beacon.latitude,
    '</div>',
    '<div class="clearfix"></div>'].join(""))

    if(project_summary['uuids'].indexOf(beacon.uuid) === -1){
        $("#modal-footer").html(
        '<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>\
        <button type="button" class="btn btn-danger" id="addToProjectBtn" >Add to project</button>'
        )
    }
    else{
        $("#modal-footer").html(
        '<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>\
        <button type="button" class="btn btn-danger" id="removeFromProjectBtn">Remove from project</button>'
        )
    }

    $("#removeFromProjectBtn").click(function(beacon){ return function(){
        $.getJSON("/api/user_project/" + project_id, function(beacon){ return function(data){
            var index = data['beacon_managers'].indexOf(beacon.beacon_manager)
            data['beacon_managers'] = data['beacon_managers'].slice(index, -1);
            delete data['url'];
            $.ajax({
                url: "/api/user_project/" + project_id,
                type: 'PUT',
                data: JSON.stringify(data),
                contentType: "application/json",
                success: function(result) {
                    alert(JSON.stringify(result))
                }
            });

        }}(beacon));
    }}(beacon));

    $("#addToProjectBtn").click(function(beacon){ return function(){
        $.getJSON("/api/user_project/" + project_id, function(beacon){ return function(data){
            data['beacon_managers'].push(beacon.beacon_manager)
            delete data['url'];
            $.ajax({
                url: "/api/user_project/" + project_id,
                type: 'PUT',
                data: JSON.stringify(data),
                contentType: "application/json",
                success: function(result) {
                    alert(JSON.stringify(result))
                }
            });

        }}(beacon));
    }}(beacon));

    $("#myModal").modal("show");

//    alert('marker klikniety' + marker.beacon.uuid)
}