from django.core.exceptions import ObjectDoesNotExist
from django.shortcuts import render, render_to_response
from django.template import RequestContext

# Create your views here.
from rest_framework import viewsets
import rest_framework
from rest_framework.response import Response
from rest_framework.views import APIView
from Hub.models import Beacon, BeaconManager, Site, Category
from Hub.serializers import BeaconSerializer, BeaconManagerSerializer, SiteSerializer, CategorySerializer


class BeaconViewSet(viewsets.ModelViewSet):
    """
    API for places
    """
    queryset = Beacon.objects.all()
    serializer_class = BeaconSerializer

class BeaconManagerViewSet(viewsets.ModelViewSet):
    """
    API for places
    """
    queryset = BeaconManager.objects.all()
    serializer_class = BeaconManagerSerializer

class SiteViewSet(viewsets.ModelViewSet):
    """
    API for places
    """
    queryset = Site.objects.all()
    serializer_class = SiteSerializer



class UuidBeaconViewSet(APIView):
    """
    API for places
    """
    queryset = Beacon.objects.all()
    serializer_class = BeaconSerializer

    def get(self, request, pk, category_name = None,format=None):
        try:
            beacon = Beacon.objects.get(uuid = pk)
        except ObjectDoesNotExist:
            return Response(status=rest_framework.status.HTTP_400_BAD_REQUEST, data={"This beacon is not exist"})
        beacon_manager = BeaconManager.objects.get(beacon=beacon)
        if category_name:
            try:
                category = Category.objects.get(name=category_name)
            except ObjectDoesNotExist:
                return Response(status=rest_framework.status.HTTP_400_BAD_REQUEST, data={"This category is not exist"})
            try:

                site = beacon_manager.sites.get(category=category)
            except ObjectDoesNotExist:
                return Response(status=rest_framework.status.HTTP_400_BAD_REQUEST, data={"Any link do not have this category"})
            serializer_sites = SiteSerializer(site, context={'request': request})
        else:
            serializer_sites = SiteSerializer(beacon_manager.sites, many=True, context={'request': request})

        serializer = BeaconManagerSerializer(beacon_manager, context={'request': request})
        serializer_data = serializer.data
        serializer_beacon = BeaconSerializer(beacon_manager.beacon, context={'request': request})
        serializer_data['sites'] = serializer_sites.data
        serializer_data['beacon'] = serializer_beacon.data
        return Response(serializer_data)

class CategoryViewSet(viewsets.ModelViewSet):
    """
    API for places
    """
    queryset = Category.objects.all()
    serializer_class = CategorySerializer


def login_page(request):
    if not request.method == 'POST':
        context = RequestContext(request)
        return render_to_response('page/login.html', {}, context)