from django.conf.urls import patterns, include, url
from django.contrib import admin
from rest_framework import routers
from django.conf.urls.static import static
from BeHub import settings

from Hub import views as hub_views
from Hub.views import login_page

router = routers.DefaultRouter()
router.register(r'beacons', hub_views.BeaconViewSet)
router.register(r'beacon_managers', hub_views.BeaconManagerViewSet)
router.register(r'category', hub_views.CategoryViewSet)
router.register(r'sites', hub_views.SiteViewSet)
router.register(r'uuid', hub_views.UuidBeaconViewSet)


urlpatterns = patterns('',
    url(r'^login/$', login_page),
    url(r'^api/', include(router.urls)),
    url(r'^admin/', include(admin.site.urls)),
    url(r'^api/uuid/(?P<pk>[0-9]+)/$', hub_views.UuidBeaconViewSet.as_view()),
    url(r'^api/uuid/(?P<pk>[0-9]+)/(?P<category_name>\w+)/$', hub_views.UuidBeaconViewSet.as_view()),

) + static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)
