from django.conf.urls import patterns, include, url
from django.contrib import admin
from rest_framework import routers

from Hub import views as hub_views

router = routers.DefaultRouter()
router.register(r'beacons', hub_views.BeaconViewSet)
router.register(r'beacon_managers', hub_views.BeaconManagerViewSet)
router.register(r'category', hub_views.CategoryViewSet)
router.register(r'sites', hub_views.SiteViewSet)
router.register(r'uuid', hub_views.UuidBeaconViewSet)


urlpatterns = patterns('',
    url(r'^api/', include(router.urls)),
    url(r'^admin/', include(admin.site.urls)),
    url(r'^api/uuid/(?P<pk>[0-9]+)/$', hub_views.UuidBeaconViewSet.as_view()),
    url(r'^api/uuid/(?P<pk>[0-9]+)/(?P<category_name>\w+)/$', hub_views.UuidBeaconViewSet.as_view()),
)
