from rest_framework import serializers
from rest_framework.decorators import detail_route, list_route
from Hub.models import Beacon, BeaconManager, Category, Site


class SiteSerializer(serializers.HyperlinkedModelSerializer):
    class Meta:
        model = Site
        fields = ('id', 'url', 'link_url', 'description', 'category')

class BeaconSerializer(serializers.HyperlinkedModelSerializer):

    class Meta:
        model = Beacon
        fields = ('id', 'url', 'uuid', 'name', 'description', 'longitude', 'latitude')

class BeaconManagerSerializer(serializers.HyperlinkedModelSerializer):
    class Meta:
        model = BeaconManager
        fields = ('id', 'url', 'sites', 'beacon')

class CategorySerializer(serializers.HyperlinkedModelSerializer):
    class Meta:
        model = Category
        fields = ('id', 'url', 'name', 'private')


