from rest_framework import serializers
from django.contrib.auth.models import User
from Hub.models import Beacon, BeaconManager, Category, Site, UserProject


class SiteSerializer(serializers.HyperlinkedModelSerializer):
    author = serializers.HyperlinkedRelatedField(view_name='user-detail', queryset=User.objects.all())
    class Meta:
        model = Site
        fields = ('id', 'url', 'link_url', 'description', 'category', 'author')



class UserSerializer(serializers.HyperlinkedModelSerializer):
    class Meta:
        model = Site
        fields = ('id', 'url')


class UserProjectSerializer(serializers.HyperlinkedModelSerializer):
    class Meta:
        model = UserProject
        fields = ('id', 'url', 'author', 'beacons', 'name', 'description')


class BeaconSerializer(serializers.HyperlinkedModelSerializer):

    class Meta:
        model = Beacon
        fields = ('id', 'url', 'uuid', 'name', 'description', 'longitude', 'latitude')

class BeaconManagerSerializer(serializers.HyperlinkedModelSerializer):
    class Meta:
        model = BeaconManager
        fields = ('id', 'url', 'sites', 'beacon')

class CategorySerializer(serializers.HyperlinkedModelSerializer):
    class Meta:
        model = Category
        fields = ('id', 'url', 'name', 'private')


